/**
 * 
 */
package gov.va.med.mhv.usermgmt.util;

import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.usermgmt.enumeration.PatientCorrelationStatus;
import gov.va.med.mhv.usermgmt.transfer.Patient;

/**
 * @author Rob Proper (Aquilent Inc.)
 *
 */
public final class PatientCorrelationStatusUtils {
    
    public static final PatientCorrelationStatus UNCORRELATED = 
        PatientCorrelationStatus.getEnum(PatientCorrelationStatus.UNCORRELATED);

    public static final PatientCorrelationStatus CORRELATED = 
        PatientCorrelationStatus.getEnum(PatientCorrelationStatus.CORRELATED);

    public static final PatientCorrelationStatus PENDING_CORRELATION = 
        PatientCorrelationStatus.getEnum(PatientCorrelationStatus.
        PENDINGCORRELATION);

    public static final PatientCorrelationStatus PENDING_UNCORRELATION = 
        PatientCorrelationStatus.getEnum(PatientCorrelationStatus.
        PENDINGUNCORRELATION);

    public static final PatientCorrelationStatus FAILED_CORRELATION = 
        PatientCorrelationStatus.getEnum(PatientCorrelationStatus.
        FAILEDCORRELATION);

    public static final PatientCorrelationStatus FAILED_UNCORRELATION = 
        PatientCorrelationStatus.getEnum(PatientCorrelationStatus.
        FAILEDUNCORRELATION);

    public static final PatientCorrelationStatus CORRELATION_INVALID = 
        PatientCorrelationStatus.getEnum(PatientCorrelationStatus.
            CORRELATIONINVALID);

    public static final PatientCorrelationStatus MVI_DATA_MATCH =
    	PatientCorrelationStatus.getEnum(PatientCorrelationStatus.
                MVIDATAMATCH);
    public static boolean isUncorrelated(Patient patient) {
        Precondition.assertNotNull("patient", patient);
        return UNCORRELATED.equals(patient.getCorrelationStatus());
    }

    public static boolean isCorrelated(Patient patient) {
        Precondition.assertNotNull("patient", patient);
        return CORRELATED.equals(patient.getCorrelationStatus());
    }

    public static boolean isPendingCorrelation(Patient patient) {
        Precondition.assertNotNull("patient", patient);
        return PENDING_CORRELATION.equals(patient.getCorrelationStatus());
    }

    public static boolean isPendingUncorrelation(Patient patient) {
        Precondition.assertNotNull("patient", patient);
        return PENDING_UNCORRELATION.equals(patient.getCorrelationStatus());
    }

    public static boolean isFailedCorrelation(Patient patient) {
        Precondition.assertNotNull("patient", patient);
        return FAILED_CORRELATION.equals(patient.getCorrelationStatus());
    }

    public static boolean isFailedUncorrelation(Patient patient) {
        Precondition.assertNotNull("patient", patient);
        return FAILED_UNCORRELATION.equals(patient.getCorrelationStatus());
    }

    public static boolean isCorrelationInvalid(Patient patient) {
        Precondition.assertNotNull("patient", patient);
        return CORRELATION_INVALID.equals(patient.getCorrelationStatus());
    }

    public static boolean isMviDataMatch(Patient patient) {
        Precondition.assertNotNull("patient", patient);
        return MVI_DATA_MATCH.equals(patient.getCorrelationStatus());
    }
    
    private PatientCorrelationStatusUtils() {
    }

}
